#importation des bibliotheques
from PIL import Image
import numpy as np

def imgpillow (filtre,nomFichier):
    imgpil = Image.fromarray(filtre)
    imgpil.show()
    imgpil.save(nomFichier)

def ouvrir_image (nomImage):
    """
    fonction qui renvoie le tableau img et affiche les info utile
    """
    #ouverture de l'image
    imgOuvert = Image.open(nomImage)
    imgOuvert.show()
    img = np.array(imgOuvert) # Transformation de l'image en tableau numpy
    
    #affichage du format, du type et de la dimension de l'image
    print("Format : ",imgOuvert.format,"\nMode : ",imgOuvert.mode,"\nDimensions : ",imgOuvert.size)
    print(img.shape)
    
    return img

#Ouverture et affichage de l'image à mettre en Rouge
img_r = ouvrir_image("673nmos.jpg")

#Ouverture et affichage de l'image à mettre en Vert
img_v = ouvrir_image("656nmos.jpg")

#Ouverture et affichage de l'image à mettre en Bleu
img_b = ouvrir_image("502nmos.jpg")

def eclaircissement(img_orig):
    """
    fonction qui renvoie l'image im_originale éclaircie
    """
    im = np.copy(img_orig) # On fait une copie de l'original
    # on parcourt tous les pixels des images
    for i in range(im.shape[0]):
        for j in range(im.shape[1]):
            r, v, b = im[i, j]  #récupération des composantes R,G,B du pixel original
            r = int(r*1.5)
            v = int(v*1.5)
            b = int(b*1.5)
            im[i, j] = (r, v,b)
    return im

imgpillow(eclaircissement(img_r),"eclaircissement_rouge.jpg")
imgpillow(eclaircissement(img_v),"eclaircissement_vert.jpg")
imgpillow(eclaircissement(img_b),"eclaircissement_bleu.jpg")

def assombrissement(img_orig):
    """
    fonction qui renvoie l'image im_originale assombrie
    """
    #Code à completer
    pass #Ligne à enlever

imgpillow(assombrissement(img_r),"assombrissement_rouge.jpg")
imgpillow(assombrissement(img_v),"assombrissement_vert.jpg")
imgpillow(assombrissement(img_b),"assombrissement_bleu.jpg")

# Écrire ici la fonction filtre_rouge
def filtre_rouge(img_orig):
    #Code à completer
    pass #Ligne à enlever

imgpillow(filtre_rouge(img_r),"rouge.jpg")

# Écrire ici la fonction filtre_vert
def filtre_vert(img_orig):
    pass #Ligne à enlever

imgpillow(filtre_vert(img_v),"vert.jpg")

# Écrire ici la fonction filtre_bleu
def filtre_bleu(img_orig):
    pass #Ligne à enlever

imgpillow(filtre_bleu(img_b),"bleu.jpg")

#Chargement et affichages des images à traiter
traitement_rouge = Image.open("rouge.jpg")
traitement_vert = Image.open("vert.jpg")
traitement_bleu = Image.open("bleu.jpg")    

def assemblage(t1,t2,t3,nomFichier):
    rendu=Image.blend(t1,t2,0.5)
    rendu=Image.blend(rendu,t3,0.5)
    rendu.show()
    rendu.save(nomFichier)

#Teste pour la fusion du calque Rouge et Vert puis du calque Bleu
assemblage (traitement_rouge,traitement_vert,traitement_bleu,"rendu_rvb.jpg")

#Teste pour la fusion du calque Rouge et Bleu puis du calque Vert
assemblage (traitement_rouge,traitement_bleu,traitement_vert,"rendu_rbv.jpg")

#Teste pour la fusion du calque Vert et Rouge puis du calque Bleu
assemblage (traitement_vert,traitement_rouge,traitement_bleu,"rendu_vrb.jpg")

#Teste pour la fusion du calque Vert et Bleu puis du calque Rouge
assemblage (traitement_vert,traitement_bleu,traitement_rouge,"rendu_vbr.jpg")

#Teste pour la fusion du calque Bleu et Vert puis du calque Rouge
assemblage (traitement_bleu,traitement_vert,traitement_rouge,"rendu_bvr.jpg")

#Teste pour la fusion du calque Bleu et Rouge puis du calque Vert
assemblage (traitement_bleu,traitement_rouge,traitement_vert,"rendu_brv.jpg")

#Pour la couche Rouge
png_r = ouvrir_image("673nmos.png")

def filtre_rouge_png(img_orig):
    #Code à completer
    pass #Ligne à enlever

imgpillow(filtre_rouge_png(png_r),"rouge.png")

#Pour la couche Verte
png_v = ouvrir_image("656nmos.png")


def filtre_vert_png(img_orig):
    #Code à completer 
    pass #Ligne à enlever

imgpillow(filtre_vert_png(png_v),"vert.png")

#Pour la couche bleu
png_b = ouvrir_image("502nmos.png")

def filtre_bleu_png(img_orig):
    #Code à completer
    pass #Ligne à enlever

imgpillow(filtre_bleu_png(png_b),"bleu.png")

traitement_rouge = Image.open("rouge.png")
traitement_vert = Image.open("vert.png")
traitement_bleu = Image.open("bleu.png")

assemblage (traitement_rouge,traitement_vert,traitement_bleu,"rendu.png")
